import random

sentences = {
    "Python Shell, is a REPL environment used to run snippets of Python code, typically a single statement at a time.": 't',
    "A collection of related functions makes up a module, and there are lots of modules in the standard library.": 't',
    "Python uses indentation to demarcate a block of code, which Python programmers prefer to call suite as opposed to block. It is introduced by a colon.": 't',
    "The for loop is perfect for controlling looping when you know ahead of time how many iterations you need. (When you don’t know, we recommend the while loop)": 't',
    "Don’t mix tabs with spaces in your Python code. Configure your editor to replace a tap of the Tab key with four spaces and automatically remove any trailing whitespace.": 't',
    "The three arguments of the range() function are start, stop, step": 't',
    "A list is an ordered mutable collection of objects enclosed in square brackets with the objects separated by a comma": 't',
    "Lists allow for the operations pop, remove, extend, and insert, among many others.": 't',
    "Lists can be grown at runtime or created literally.": 't',
    "Using an assignment operator doesn't create a copy, but creates two references to the same data structure.": 't',
    "To copy a data structure we use the .copy function.": 't',
    "The square bracket notation for lists allows for start, stop, step from start to end or from end to start.": 't',
    "booklist[-6:] is called 'list slicing' and extracts a portion of the list starting from the sixth element from the end and includes all elements until the end of the list.": 't',
    "booklist[::-1] will return a new list that contains all elements of booklist in reverse order.": 't',
    "List methods change the state of a list, whereas using square brackets and slices (typically) does not.": 't',
    "A dictionary in Python is enclosed in curly braces. Keys and values are enclosed in quotes if they are strings. Each key is separated from its associated value by a colon (:), and each key-value pair is separated by a comma.": 't',
    "A tuple is an ordered immutable collection of objects": 't',
    "A dictionary is an unordered set of key/value pairs": 't',
    "The items method with a for loop is a technique for iterating over a dictionary. It gives access to key and value as loop variables.": 't',
    "if 'key' not in dict: \nfruits['pears'] = 0 \n\ndoes the same as \n\nfruits.setdefault('pears', 0)": 't',
    "Sets are preferred over lists for lookup.": 't',
    "vowels = { 'a', 'e', 'e', 'i', 'o', 'u', 'u' }\n\ndoes the same thing as \n\nvowels2 = set('aeeiouu')": 't',
    "Tuples are surrounded by parentheses, whereas lists use square brackets.": 't',
    "t = ('Python',) \ncreates a tuple with just one string.": 't',
    "Strings enclosed by a single quote character (') or a double quote character (\") cannot span multiple lines": 't',
    "PEP 8 is the style guide for Python code.": 't',
    "Every object in Python has a truth value associated with it.": 't',
    "If an object evaluates to 0, it is always False": 't',
    "An empty string, an empty list, and an empty dictionary all evaluate to False.": 't',
    "The “None” value is always False.": 't',
    "A number that isn’t 0 is always True, even when it’s negative.": 't',
    "A nonempty string is always True.": 't',
    "A nonempty built-in data structure is always True.": 't',
    "{} represents an empty dictionary": 't',
    "An empty set is represented as set() by the interpreter.": 't',
    "Any argument to a Python function can be assigned a default value.": 't',
    "To use keyword assignment, assign each string in any order to its correct argument name when invoking a function.": 't',
    "The interpreter’s site-packages locations are the directories that contain any installed or self-written Python modules not in the standard library.": 't',
    "The interpreter always searches your current working directory for modules first.": 't',
    "If the interpreter can’t find your module in the current working directory, it looks in the site-packages locations as well as in the standard library.": 't',
    "A set is an unordered set of unique objects": 't',

    "Python Shell, is a REPL environment used to run snippets of Python code, typically multiple statements at a time.": 'f',
    "A collection of related functions makes up a library.": 'f',
    "Python uses indentation to demarcate code which Python programmers call a block. It is introduced by a semicolon.": 'f',
    "The for loop is perfect for controlling looping when you don't know ahead of time how many iterations you need.": 'f',
    "If you mix tabs with spaces in your Python code, configure your editor to replace a tap of the Tab key with two spaces and automatically remove trailing whitespace.": 'f',
    "The four arguments of the range() function are start, stop, step, size": 'f',
    "A list is an unordered mutable collection of objects enclosed in parentheses with the objects separated by a comma": 'f',
    "Lists allow for the operations push, delete, expand, and insert, among many others.": 'f',
    "Lists cannot be grown at runtime or created literally.": 'f',
    "Using an assignment operator creates a copy, resulting in two separate data structures.": 'f',
    "To copy a data structure, we use the .clone function.": 'f',
    "The square bracket notation for lists does not support specifying start, stop, step values.": 'f',
    "booklist[-6:] is called 'list slicing' and extracts a portion of the list starting from the sixth element from the beginning and includes all elements until the end of the list.": 'f',
    "booklist[::-1] will return the original list reduced by one.": 'f',
    "List methods do not change the state of a list, whereas using square brackets and slices (typically) modifies the list.": 'f',
    "A dictionary in Python is enclosed in square brackets. Keys and values are enclosed in quotes if they are strings. Each key is separated from its associated value by a comma, and there is no specific format.": 'f',
    "A tuple is an unordered immutable collection of objects": 'f',
    "A dictionary is an ordered set of key/value pairs": 'f',
    "t = ('Python') \ncreates a tuple with just one string.": 'f',
    "A set is an ordered collection of unique objects": 'f',
    "The interpreter always searches the standard library for modules first.": 'f',
    "Strings enclosed by a single quote character (') and a double quote character (\") can span multiple lines.": 'f',
    "PEP 1.8 is the style guide for Python code.": 'f',
    "Apart from truth values themselves, every object in Python has a truth value associated with it.": 'f',
    "If an object evaluates to 0, it is always True": 'f',
    "The bool() function evaluates empty strings to 0.": 'f',
    "The “None” value is always True.": 'f',
    "A number that isn’t 0 is always False, even when it’s negative.": 'f',
    "A nonempty string is always False.": 'f',
    "A nonempty built-in data structure is always False.": 'f',
    "{} represents an empty list": 'f',
    "An empty set is represented as {} by the interpreter.": 'f',
    "To use positional assignment, assign each string to its argument place by using the equal sign when invoking a function.": 'f',
    "The interpreter’s site-packages locations are the directories that contain any installed or self-written Python modules in the standard library.": 'f',
    "The interpreter always searches your current working directory for modules last.": 'f',
    "If the interpreter can’t find your module in the current working directory, it will use setuptools to look for it.": 'f'

}

sentence_items = list(sentences.items())
random_sentences = []
used_indexes = []

while len(random_sentences) < 5:
    random_index = random.randint(0, len(sentence_items) - 1)
    if random_index not in used_indexes:
        random_sentence = sentence_items[random_index]
        random_sentences.append(random_sentence)
        used_indexes.append(random_index)

print("\n\nOh, you again! Well, since you're already here, \nwelcome to Jan Fliessbach's wordy and passive-aggressive quiz on Head First Python. \nYou will evaluate 5 statements as either t for TRUE or f for FALSE. \nPlease don't disappoint me here, these are really basic things...\n")

for sentence, answer in random_sentences:
    for _ in range(3):  
        user_input = input("****************STATEMENT****************\n" + sentence + " \n(type t for TRUE/f for FALSE): ").lower()
        if user_input == 't' or user_input == 'f':
            break
        else:
            print("\n ¯\_(ツ)_/¯ Invalid input. \nWhat exactly am I supposed to do with that? \nPlease enter 't' for TRUE or 'f' for FALSE. \nI mean it's just two letters, how simple do these people...")
    else:
        print("You know what...\nI've had enough of this nonsense. \nYou've exceeded the maximum attempts. \nSince you don't seem to get it, I'm moving to the next question. \n")
        continue
    
    if user_input == answer:
        print("\nCorrect! This was easy anyways...")
    else:
        print("\nIncorrect. Please try a bit harder...")






